<?php
/**
 * Title: Page Style Guide
 * Slug: style-guide
 * Categories: page
 * Block Types: core/post-content
 */
?>
<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|lg","bottom":"var:preset|spacing|lg"}},"position":{"all":"relative"},"zIndex":{"all":"1"},"boxShadow":""},"layout":{"type":"constrained"},"shadowPreset":"xs","shadowPresetHover":""} -->
<div class="wp-block-group alignfull  has-shadow has-xs-shadow" style="padding-top:var(--wp--preset--spacing--lg);padding-bottom:var(--wp--preset--spacing--lg)"><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0"}}},"className":"is-style-sub-heading"} -->
<p class="aligncenter has-text-align-center is-style-sub-heading aligncenter" style="margin-top:0">{site_name}</p>
<!-- /wp:paragraph -->
<!-- wp:post-title {"textAlign":"center","level":1} /--></div>
<!-- /wp:group -->
<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-50","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-neutral-50-background-color has-background" style="margin-top:0;margin-bottom:0"><!-- wp:columns {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl","bottom":"var:preset|spacing|xxl"},"blockGap":{"top":"var:preset|spacing|lg","left":"var:preset|spacing|lg"}}}} -->
<div class="wp-block-columns alignwide" style="padding-top:var(--wp--preset--spacing--xl);padding-bottom:var(--wp--preset--spacing--xxl)"><!-- wp:column {"width":"25%","style":{"position":{"all":"sticky","mobile":"relative"},"top":{"all":"2em"},"display":{"mobile":"none"},"right":{"all":""},"bottom":{"all":"2em"},"left":{"all":""}}} -->
<div class="wp-block-column" style="flex-basis:25%"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|sm","bottom":"var:preset|spacing|sm","left":"var:preset|spacing|sm","right":"var:preset|spacing|sm"},"margin":{"top":"0","bottom":"0"},"blockGap":"var:preset|spacing|xxs"},"typography":{"textDecoration":"none","fontStyle":"normal","fontWeight":"500"}},"className":"is-style-surface","layout":{"type":"flex","orientation":"vertical"},"fontSize":"14"} -->
<div class="wp-block-group is-style-surface has-14-font-size" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--sm);padding-right:var(--wp--preset--spacing--sm);padding-bottom:var(--wp--preset--spacing--sm);padding-left:var(--wp--preset--spacing--sm);font-style:normal;font-weight:500;text-decoration:none"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#color-palette">Colors</a></p>
<!-- /wp:paragraph -->
<!-- wp:list {"style":{"spacing":{"blockGap":"0"},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"neutral-600","className":"is-style-dash","fontSize":"14"} -->
<ul style="font-style:normal;font-weight:400" class="is-style-dash has-neutral-600-color has-text-color has-14-font-size"><!-- wp:list-item -->
<li><a href="#primary">Primary</a></li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li><a href="#neutral">Neutral</a></li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li><a href="#status">Status</a></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#gradients">Gradients</a> </p>
<!-- /wp:paragraph -->
<!-- wp:list {"style":{"spacing":{"blockGap":"0"},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"neutral-600","className":"is-style-dash","fontSize":"14"} -->
<ul style="font-style:normal;font-weight:400" class="is-style-dash has-neutral-600-color has-text-color has-14-font-size"><!-- wp:list-item -->
<li><a href="#primary">Theme</a></li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li><a href="#default">Default</a></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#typography">Typography</a></p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#spacing-scale">Spacing</a></p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#shadows">Shadows</a></p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#elements">Elements</a></p>
<!-- /wp:paragraph -->
<!-- wp:list {"style":{"spacing":{"blockGap":"0"},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"neutral-600","className":"is-style-dash","fontSize":"14"} -->
<ul style="font-style:normal;font-weight:400" class="is-style-dash has-neutral-600-color has-text-color has-14-font-size"><!-- wp:list-item -->
<li><a href="#buttons">Buttons</a></li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li><a href="#buttons">Forms</a></li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li><a href="#wordpress">Notices</a></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading"><a href="#icons">Icons</a></p>
<!-- /wp:paragraph -->
<!-- wp:list {"style":{"spacing":{"blockGap":"0"},"typography":{"fontStyle":"normal","fontWeight":"400"}},"textColor":"neutral-600","className":"is-style-dash","fontSize":"14"} -->
<ul style="font-style:normal;font-weight:400" class="is-style-dash has-neutral-600-color has-text-color has-14-font-size"><!-- wp:list-item -->
<li><a href="#buttons">WordPress</a></li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li><a href="#social">Social</a></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->
<!-- wp:column {"width":"75%"} -->
<div class="wp-block-column" style="flex-basis:75%"><!-- wp:group {"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|md","margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignfull" style="margin-top:0;margin-bottom:0"><!-- wp:heading {"textAlign":"wide","style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"var:preset|spacing|xs","left":"0"}},"typography":{"lineHeight":"1"}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:var(--wp--preset--spacing--xs);margin-left:0;line-height:1">Color Palette</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs","right":"0","bottom":"0","left":"0"}}},"className":"is-style-default"} -->
<p class="is-style-default" style="margin-top:var(--wp--preset--spacing--xxs);margin-right:0;margin-bottom:0;margin-left:0">Default color palette for creating beautiful designs</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:pattern {"slug":"utility-color-palette","preview":true} /--></div>
<!-- /wp:group -->
<!-- wp:heading {"textAlign":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl"},"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:var(--wp--preset--spacing--xl)">Gradients</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--xxs)">For use with text, backgrounds, box shadows and borders</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:pattern {"slug":"utility-gradients","preview":true} /--></div>
<!-- /wp:group -->
<!-- wp:heading {"textAlign":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl"},"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:var(--wp--preset--spacing--xl)">Typography</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--xxs)">For use with text, backgrounds, box shadows and borders</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:group {"align":"full","layout":{"type":"default"},"fontSize":"14"} -->
<div class="wp-block-group alignfull has-14-font-size"><!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Display / 60px</p>
<!-- /wp:paragraph -->
<!-- wp:heading {"level":1,"style":{"typography":{"lineHeight":"1"}},"fontSize":"60"} -->
<h1 class="wp-block-heading has-60-font-size" style="line-height:1">Almost before we knew it we had left the ground.</h1>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md"}}},"textColor":"neutral-200"} -->
<hr class="wp-block-separator has-alpha-channel-opacity has-neutral-200-color has-text-color has-neutral-200-color has-text-color" style="margin-top:var(--wp--preset--spacing--md);margin-bottom:var(--wp--preset--spacing--md)"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Heading 1 / 44px</p>
<!-- /wp:paragraph -->
<!-- wp:heading {"level":1,"fontSize":"44"} -->
<h1 class="wp-block-heading has-44-font-size">Almost before we knew it we had left the ground.</h1>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Heading 2 / 36px</p>
<!-- /wp:paragraph -->
<!-- wp:heading -->
<h2 class="wp-block-heading">Almost before we knew it we had left the ground.</h2>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Heading 3 / 32px</p>
<!-- /wp:paragraph -->
<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading">Almost before we knew it we had left the ground.</h3>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark"} -->
<p class="has-grey-dark-color has-text-color">Heading 4 / 28px</p>
<!-- /wp:paragraph -->
<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Almost before we knew it we had left the ground.</h4>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Heading 5 / 24px</p>
<!-- /wp:paragraph -->
<!-- wp:heading {"level":5,"fontSize":"24"} -->
<h5 class="wp-block-heading has-24-font-size">Almost before we knew it we had left the ground.</h5>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Heading 6 / 20px</p>
<!-- /wp:paragraph -->
<!-- wp:heading {"level":6,"fontSize":"20"} -->
<h6 class="wp-block-heading has-20-font-size">Almost before we knew it we had left the ground.</h6>
<!-- /wp:heading -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Text / 20px</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"20"} -->
<p class="has-20-font-size">Almost before we knew it we had left the ground.</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Text / 18px</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"18"} -->
<p class="has-18-font-size">Almost before we knew it we had left the ground.</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Text / 16px</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"16"} -->
<p class="has-16-font-size">Almost before we knew it we had left the ground.</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"style":{"spacing":{"margin":{"top":"2em","bottom":"2em"}}},"backgroundColor":"grey-light"} -->
<hr class="wp-block-separator has-text-color has-grey-light-color has-alpha-channel-opacity has-grey-light-background-color has-background has-grey-light-background-color has-background" style="margin-top:2em;margin-bottom:2em"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"textColor":"grey-dark","fontSize":"x-small"} -->
<p class="has-grey-dark-color has-text-color has-x-small-font-size">Text / 14px</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"14"} -->
<p class="has-14-font-size">Almost before we knew it we had left the ground.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
<!-- wp:heading {"textAlign":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl"},"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:var(--wp--preset--spacing--xl)">Spacing Scale</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--xxs)">Smart grid spacing included for consistent layouts</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|sm","right":"var:preset|spacing|sm","bottom":"var:preset|spacing|sm","left":"var:preset|spacing|sm"},"blockGap":"var:preset|spacing|xs"},"border":{"width":"1px","radius":"3px"}},"backgroundColor":"neutral-50","className":"is-style-default","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-default has-neutral-50-background-color has-background" style="border-width:1px;border-radius:3px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--sm);padding-right:var(--wp--preset--spacing--sm);padding-bottom:var(--wp--preset--spacing--sm);padding-left:var(--wp--preset--spacing--sm)"><!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"14"} -->
<div class="wp-block-group has-14-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-heading"} -->
<p class="is-style-heading">Name</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-heading"} -->
<p class="is-style-heading">Token</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}},"className":"is-style-heading"} -->
<p class="is-style-heading">Size</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Width</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">XX Small</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-xxs</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>8px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"8px"},"border":{"radius":"3px"},"layout":{"flexSize":"8px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">X Small</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-xs</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>16px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"16px"},"border":{"radius":"3px"},"layout":{"flexSize":"16px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">Small</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-sm</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>24px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"24px"},"border":{"radius":"3px"},"layout":{"flexSize":"24px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">Medium</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-md</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>32px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"32px"},"border":{"radius":"3px"},"layout":{"flexSize":"32px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">Large</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-lg</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>48px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"48px"},"border":{"radius":"3px"},"layout":{"flexSize":"48px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">X Large</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-xl</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>64px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"64px"},"border":{"radius":"3px"},"layout":{"flexSize":"64px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"bottom":"var:preset|spacing|xs"}},"border":{"bottom":{"width":"1px"}}},"layout":{"type":"flex","flexWrap":"nowrap"},"fontSize":"12"} -->
<div class="wp-block-group has-12-font-size" style="border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--xs)"><!-- wp:paragraph {"style":{"width":{"all":"64px"}},"className":"is-style-default"} -->
<p class="is-style-default">XX Large</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"80px"}},"className":"is-style-default"} -->
<p class="is-style-default">spacing-xxl</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"width":{"all":"44px"}}} -->
<p>96px</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"30px","width":"0px","style":{"width":{"all":"96px"},"border":{"radius":"3px"},"layout":{"flexSize":"96px","selfStretch":"fixed"}},"shadowPreset":"md","backgroundColor":"white"} -->
<div style="border-radius:3px;height:30px;width:0px" aria-hidden="true" class="wp-block-spacer has-white-background-color has-background  has-shadow has-md-shadow"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
<!-- wp:heading {"textAlign":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl"},"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:var(--wp--preset--spacing--xl)">Shadows</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--xxs)">Subtle shadow scale presets</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (xxs)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--xxs)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"xxs","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-xxs-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (xs)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--xs)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"xs","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-xs-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (sm)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--sm)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"sm","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-sm-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (md)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--md)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"md","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-md-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (lg)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--lg)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"lg","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-lg-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (xl)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--xl)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"xl","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-xl-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:paragraph {"className":"is-style-heading"} -->
<p class="is-style-heading">Shadow (xxl)</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"className":"is-style-default","fontSize":"12"} -->
<p class="is-style-default has-12-font-size" style="margin-top:0;margin-bottom:0">var(--wp--preset--shadow--xxl)</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"66.66%","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"neutral-0","className":"is-style-surface","shadowPreset":"xxl","shadowPresetHover":"xxs"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-surface has-neutral-0-background-color has-background  has-shadow has-xxl-shadow has-xxs-shadow-hover" style="margin-top:0;margin-bottom:0;flex-basis:66.66%"><!-- wp:spacer {"height":"var:preset|spacing|lg"} -->
<div style="height:var(--wp--preset--spacing--lg)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->
<!-- wp:heading {"textAlign":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl"},"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:var(--wp--preset--spacing--xl)">Elements</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--xxs)">Common HTML element styles</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:heading {"level":3,"fontSize":"inherit","shadowPreset":"","shadowPresetHover":""} -->
<h3 class="wp-block-heading has-inherit-font-size">Buttons</h3>
<!-- /wp:heading -->
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xs"}},"layout":{"type":"flex","flexWrap":"wrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:buttons {"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-buttons"><!-- wp:button {"size":"large","iconSet":"","iconName":"blockify","iconSize":"20","iconPosition":"end","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 style=\u0022enable-background:new 0 0 2000 2000\u0022 viewBox=\u00220 0 2000 2000\u0022\u003e\u003cpath fill=\u0022currentColor\u0022 d=\u0022m1729.66 534.39-691.26-399.1a76.814 76.814 0 0 0-76.81 0l-691.26 399.1a76.818 76.818 0 0 0-38.4 66.52v798.19c0 27.44 14.64 52.8 38.4 66.52l691.26 399.1c11.88 6.86 25.14 10.29 38.4 10.29s26.52-3.43 38.4-10.29l691.26-399.1a76.818 76.818 0 0 0 38.4-66.52V600.9c.01-27.44-14.63-52.79-38.39-66.51zm-115.21 820.36-539.18 311.3V998.46c0-27.45-14.65-52.81-38.43-66.53l-574.18-331.2L1000 290.49l614.45 354.75v709.51z\u0022/\u003e\u003c/svg\u003e"} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Button Primary</a></div>
<!-- /wp:button -->
<!-- wp:button {"size":"medium","iconSet":"","iconName":"blockify","iconSize":"20","iconPosition":"end","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 style=\u0022enable-background:new 0 0 2000 2000\u0022 viewBox=\u00220 0 2000 2000\u0022\u003e\u003cpath fill=\u0022currentColor\u0022 d=\u0022m1729.66 534.39-691.26-399.1a76.814 76.814 0 0 0-76.81 0l-691.26 399.1a76.818 76.818 0 0 0-38.4 66.52v798.19c0 27.44 14.64 52.8 38.4 66.52l691.26 399.1c11.88 6.86 25.14 10.29 38.4 10.29s26.52-3.43 38.4-10.29l691.26-399.1a76.818 76.818 0 0 0 38.4-66.52V600.9c.01-27.44-14.63-52.79-38.39-66.51zm-115.21 820.36-539.18 311.3V998.46c0-27.45-14.65-52.81-38.43-66.53l-574.18-331.2L1000 290.49l614.45 354.75v709.51z\u0022/\u003e\u003c/svg\u003e"} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Button Primary</a></div>
<!-- /wp:button -->
<!-- wp:button {"size":"small","iconSet":"","iconName":"blockify","iconSize":"20","iconPosition":"end","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 style=\u0022enable-background:new 0 0 2000 2000\u0022 viewBox=\u00220 0 2000 2000\u0022\u003e\u003cpath fill=\u0022currentColor\u0022 d=\u0022m1729.66 534.39-691.26-399.1a76.814 76.814 0 0 0-76.81 0l-691.26 399.1a76.818 76.818 0 0 0-38.4 66.52v798.19c0 27.44 14.64 52.8 38.4 66.52l691.26 399.1c11.88 6.86 25.14 10.29 38.4 10.29s26.52-3.43 38.4-10.29l691.26-399.1a76.818 76.818 0 0 0 38.4-66.52V600.9c.01-27.44-14.63-52.79-38.39-66.51zm-115.21 820.36-539.18 311.3V998.46c0-27.45-14.65-52.81-38.43-66.53l-574.18-331.2L1000 290.49l614.45 354.75v709.51z\u0022/\u003e\u003c/svg\u003e"} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Button Primary</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- wp:buttons {"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-ghost","size":"large","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-ghost"><a class="wp-block-button__link wp-element-button">Button Ghost</a></div>
<!-- /wp:button -->
<!-- wp:button {"className":"is-style-ghost","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-ghost"><a class="wp-block-button__link wp-element-button">Button Ghost</a></div>
<!-- /wp:button -->
<!-- wp:button {"className":"is-style-ghost","size":"small","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-ghost"><a class="wp-block-button__link wp-element-button">Button Ghost</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- wp:buttons {"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"boxShadow":""},"className":"is-style-outline","shadowPreset":"","shadowPresetHover":"","size":"large","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button">Button Outline</a></div>
<!-- /wp:button -->
<!-- wp:button {"className":"is-style-outline","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button">Button Outline</a></div>
<!-- /wp:button -->
<!-- wp:button {"className":"is-style-outline","size":"small","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button">Button Outline</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- wp:buttons {"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-buttons"><!-- wp:button {"textColor":"current","className":"is-style-outline","size":"large","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-current-color has-text-color wp-element-button">Outline Neutral</a></div>
<!-- /wp:button -->
<!-- wp:button {"textColor":"current","className":"is-style-outline","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-current-color has-text-color wp-element-button">Outline Neutral</a></div>
<!-- /wp:button -->
<!-- wp:button {"textColor":"current","className":"is-style-outline","size":"small","iconSize":"20","iconPosition":"end"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-current-color has-text-color wp-element-button">Outline Neutral</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->
<!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|md","left":"0"}}},"fontSize":"inherit","shadowPreset":"","shadowPresetHover":""} -->
<h3 class="wp-block-heading has-inherit-font-size" style="margin-top:var(--wp--preset--spacing--md);margin-left:0">Forms</h3>
<!-- /wp:heading -->
<!-- wp:html -->
<form>
    <input type="text" name="name" placeholder="Name" required>
    <input type="email" name="email" placeholder="Email" required>
    <select name="country">
        <option value="" disabled selected>Country</option>
        <option value="usa">United States</option>
        <option value="canada">Canada</option>
        <option value="uk">United Kingdom</option>
    </select><br>
    <textarea name="message" placeholder="Message" rows="4"></textarea>
<br>
    <label for="subscribe" class="has-14-font-size">
        <input type="checkbox" id="subscribe" name="subscribe" value="yes">
        Subscribe to our newsletter
    </label>
    <br>
    <input type="submit" value="Submit">
</form>
<!-- /wp:html -->
<!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|md","left":"0"}}},"fontSize":"inherit","shadowPreset":"","shadowPresetHover":""} -->
<h3 class="wp-block-heading has-inherit-font-size" style="margin-top:var(--wp--preset--spacing--md);margin-left:0">Notices</h3>
<!-- /wp:heading -->
<!-- wp:group {"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"width":{"all":"100%"}},"className":"has-border-color has-primary-500-border-color is-style-notice"} -->
<p class="has-border-color has-primary-500-border-color is-style-notice"><strong>Info</strong>: These are the default styles provided by the theme. Every setting can be changed easily from within WordPress.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"color":{"text":"#00c648"},"width":{"all":"100%"}},"className":"has-border-color is-style-notice"} -->
<p class="has-border-color is-style-notice has-text-color" style="color:#00c648"><strong>Success</strong>: These are the default styles provided by the theme. Every setting can be changed easily from within WordPress.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"color":{"text":"#baa500"},"width":{"all":"100%"}},"className":"has-border-color is-style-notice"} -->
<p class="has-border-color is-style-notice has-text-color" style="color:#baa500"><strong>Warning</strong>: These are the default styles provided by the theme. Every setting can be changed easily from within WordPress.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|xxs"}},"color":{"text":"#e8384a"},"width":{"all":"100%"}},"className":"has-border-color is-style-notice"} -->
<p class="has-border-color is-style-notice has-text-color" style="color:#e8384a;margin-bottom:var(--wp--preset--spacing--xxs)"><strong>Error</strong>: These are the default styles provided by the theme. Every setting can be changed easily from within WordPress.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
<!-- wp:heading {"textAlign":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|xl"},"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"fontSize":"20"} -->
<h2 class="wp-block-heading has-text-align-wide has-20-font-size" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:var(--wp--preset--spacing--xl)">Icons</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--xxs)">Default icon sets included with theme. Custom icon sets can be added to child themes.</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","left":"var:preset|spacing|md","right":"var:preset|spacing|md"}}},"className":"is-style-surface","layout":{"type":"default"}} -->
<div class="wp-block-group is-style-surface" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:var(--wp--preset--spacing--md);padding-left:var(--wp--preset--spacing--md)"><!-- wp:heading {"level":3,"fontSize":"inherit","shadowPreset":"","shadowPresetHover":""} -->
<h3 class="wp-block-heading has-inherit-font-size">WordPress</h3>
<!-- /wp:heading -->
<!-- wp:image {"align":"left","className":"is-style-icon all-icons","iconSet":"wordpress","iconName":"star-empty","iconSize":"2em"} -->
<figure class="wp-block-image alignleft is-style-icon all-icons" style="--wp--custom--icon--size:2em;--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path fill-rule=&quot;evenodd&quot; d=&quot;M9.706 8.646a.25.25 0 01-.188.137l-4.626.672a.25.25 0 00-.139.427l3.348 3.262a.25.25 0 01.072.222l-.79 4.607a.25.25 0 00.362.264l4.138-2.176a.25.25 0 01.233 0l4.137 2.175a.25.25 0 00.363-.263l-.79-4.607a.25.25 0 01.072-.222l3.347-3.262a.25.25 0 00-.139-.427l-4.626-.672a.25.25 0 01-.188-.137l-2.069-4.192a.25.25 0 00-.448 0L9.706 8.646zM12 7.39l-.948 1.921a1.75 1.75 0 01-1.317.957l-2.12.308 1.534 1.495c.412.402.6.982.503 1.55l-.362 2.11 1.896-.997a1.75 1.75 0 011.629 0l1.895.997-.362-2.11a1.75 1.75 0 01.504-1.55l1.533-1.495-2.12-.308a1.75 1.75 0 01-1.317-.957L12 7.39z&quot; clip-rule=&quot;evenodd&quot;&gt; </path&gt;</svg&gt;')"><img src="" alt=""/></figure>
<!-- /wp:image -->
<!-- wp:heading {"level":3,"style":{"spacing":{"padding":{"top":"var:preset|spacing|sm"}}},"fontSize":"inherit","shadowPreset":"","shadowPresetHover":""} -->
<h3 class="wp-block-heading has-inherit-font-size" style="padding-top:var(--wp--preset--spacing--sm)">Social</h3>
<!-- /wp:heading -->
<!-- wp:image {"align":"left","className":"is-style-icon all-icons","iconSet":"social","iconName":"amazon","iconSize":"2em","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath d=\u0022M11.340 2.023 C 10.422 2.115,9.894 2.213,9.280 2.409 C 7.819 2.873,6.659 3.836,6.104 5.045 C 5.919 5.447,5.723 6.079,5.696 6.354 C 5.671 6.625,5.754 6.791,5.965 6.888 C 6.127 6.963,8.786 7.258,8.956 7.221 C 9.151 7.178,9.306 6.955,9.396 6.585 C 9.626 5.642,10.488 5.037,11.600 5.037 C 12.265 5.037,12.643 5.167,13.027 5.530 C 13.446 5.927,13.558 6.331,13.559 7.450 C 13.560 8.092,13.551 8.200,13.500 8.200 C 13.330 8.200,11.416 8.417,10.855 8.500 C 8.794 8.805,7.573 9.312,6.618 10.260 C 5.541 11.330,5.044 12.862,5.244 14.500 C 5.504 16.630,6.761 17.927,8.831 18.204 C 9.269 18.263,10.329 18.229,10.820 18.141 C 11.905 17.946,12.786 17.470,13.724 16.570 C 13.936 16.367,14.119 16.200,14.130 16.200 C 14.141 16.200,14.317 16.435,14.521 16.721 C 14.982 17.369,15.669 18.052,15.930 18.123 C 16.195 18.194,16.350 18.098,17.289 17.280 C 17.756 16.873,18.264 16.431,18.419 16.297 C 18.574 16.164,18.725 16.003,18.756 15.939 C 18.848 15.750,18.760 15.531,18.381 15.006 C 18.195 14.748,17.972 14.385,17.886 14.199 C 17.576 13.530,17.590 13.737,17.559 9.620 C 17.530 5.674,17.532 5.720,17.317 5.019 C 16.753 3.178,14.876 2.079,12.200 2.022 C 11.815 2.014,11.428 2.015,11.340 2.023 M13.560 11.430 C 13.560 12.092,13.541 12.495,13.498 12.760 C 13.249 14.298,12.269 15.364,11.096 15.370 C 10.495 15.373,10.038 15.144,9.730 14.686 C 9.464 14.290,9.381 13.967,9.381 13.320 C 9.380 12.704,9.424 12.476,9.630 12.040 C 9.734 11.820,9.848 11.664,10.056 11.456 C 10.665 10.846,11.758 10.496,13.090 10.484 L 13.560 10.480 13.560 11.430 M20.540 17.205 C 19.953 17.278,19.250 17.530,18.890 17.795 C 18.716 17.923,18.667 18.062,18.779 18.105 C 18.812 18.118,19.183 18.097,19.603 18.059 C 20.412 17.985,21.205 17.994,21.420 18.078 C 21.486 18.104,21.581 18.163,21.630 18.210 C 21.829 18.396,21.709 19.146,21.312 20.197 C 20.999 21.027,21.002 21.014,21.048 21.070 C 21.130 21.168,21.251 21.116,21.500 20.877 C 21.932 20.463,22.258 19.910,22.500 19.187 C 22.734 18.488,22.816 17.733,22.683 17.486 C 22.550 17.237,21.446 17.092,20.540 17.205 M1.280 17.680 C 1.220 17.793,1.268 17.864,1.608 18.164 C 3.933 20.215,6.879 21.498,10.200 21.906 C 11.014 22.006,12.866 22.006,13.680 21.906 C 15.870 21.637,17.994 20.966,19.620 20.029 C 20.004 19.808,20.597 19.412,20.730 19.288 C 20.943 19.089,20.825 18.760,20.542 18.760 C 20.475 18.760,20.174 18.858,19.873 18.977 C 18.464 19.535,16.883 19.963,15.340 20.203 C 13.561 20.481,11.499 20.515,9.700 20.298 C 7.021 19.974,4.374 19.144,2.113 17.918 C 1.501 17.587,1.353 17.544,1.280 17.680 \u0022 stroke=\u0022none\u0022 fill-rule=\u0022evenodd\u0022 \u003e\u003c/path\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image alignleft is-style-icon all-icons" style="--wp--custom--icon--size:2em;--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path d=&quot;M11.340 2.023 C 10.422 2.115,9.894 2.213,9.280 2.409 C 7.819 2.873,6.659 3.836,6.104 5.045 C 5.919 5.447,5.723 6.079,5.696 6.354 C 5.671 6.625,5.754 6.791,5.965 6.888 C 6.127 6.963,8.786 7.258,8.956 7.221 C 9.151 7.178,9.306 6.955,9.396 6.585 C 9.626 5.642,10.488 5.037,11.600 5.037 C 12.265 5.037,12.643 5.167,13.027 5.530 C 13.446 5.927,13.558 6.331,13.559 7.450 C 13.560 8.092,13.551 8.200,13.500 8.200 C 13.330 8.200,11.416 8.417,10.855 8.500 C 8.794 8.805,7.573 9.312,6.618 10.260 C 5.541 11.330,5.044 12.862,5.244 14.500 C 5.504 16.630,6.761 17.927,8.831 18.204 C 9.269 18.263,10.329 18.229,10.820 18.141 C 11.905 17.946,12.786 17.470,13.724 16.570 C 13.936 16.367,14.119 16.200,14.130 16.200 C 14.141 16.200,14.317 16.435,14.521 16.721 C 14.982 17.369,15.669 18.052,15.930 18.123 C 16.195 18.194,16.350 18.098,17.289 17.280 C 17.756 16.873,18.264 16.431,18.419 16.297 C 18.574 16.164,18.725 16.003,18.756 15.939 C 18.848 15.750,18.760 15.531,18.381 15.006 C 18.195 14.748,17.972 14.385,17.886 14.199 C 17.576 13.530,17.590 13.737,17.559 9.620 C 17.530 5.674,17.532 5.720,17.317 5.019 C 16.753 3.178,14.876 2.079,12.200 2.022 C 11.815 2.014,11.428 2.015,11.340 2.023 M13.560 11.430 C 13.560 12.092,13.541 12.495,13.498 12.760 C 13.249 14.298,12.269 15.364,11.096 15.370 C 10.495 15.373,10.038 15.144,9.730 14.686 C 9.464 14.290,9.381 13.967,9.381 13.320 C 9.380 12.704,9.424 12.476,9.630 12.040 C 9.734 11.820,9.848 11.664,10.056 11.456 C 10.665 10.846,11.758 10.496,13.090 10.484 L 13.560 10.480 13.560 11.430 M20.540 17.205 C 19.953 17.278,19.250 17.530,18.890 17.795 C 18.716 17.923,18.667 18.062,18.779 18.105 C 18.812 18.118,19.183 18.097,19.603 18.059 C 20.412 17.985,21.205 17.994,21.420 18.078 C 21.486 18.104,21.581 18.163,21.630 18.210 C 21.829 18.396,21.709 19.146,21.312 20.197 C 20.999 21.027,21.002 21.014,21.048 21.070 C 21.130 21.168,21.251 21.116,21.500 20.877 C 21.932 20.463,22.258 19.910,22.500 19.187 C 22.734 18.488,22.816 17.733,22.683 17.486 C 22.550 17.237,21.446 17.092,20.540 17.205 M1.280 17.680 C 1.220 17.793,1.268 17.864,1.608 18.164 C 3.933 20.215,6.879 21.498,10.200 21.906 C 11.014 22.006,12.866 22.006,13.680 21.906 C 15.870 21.637,17.994 20.966,19.620 20.029 C 20.004 19.808,20.597 19.412,20.730 19.288 C 20.943 19.089,20.825 18.760,20.542 18.760 C 20.475 18.760,20.174 18.858,19.873 18.977 C 18.464 19.535,16.883 19.963,15.340 20.203 C 13.561 20.481,11.499 20.515,9.700 20.298 C 7.021 19.974,4.374 19.144,2.113 17.918 C 1.501 17.587,1.353 17.544,1.280 17.680 &quot; stroke=&quot;none&quot; fill-rule=&quot;evenodd&quot; &gt;</path&gt;</svg&gt;')"><img src="" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->