import React from 'react';
import EssentialLogo from './essential-logo.svg';
import NavActive from './nav-menu-active.svg';
import IconCheck from './icon-check.svg';
import IconTimes from './icon-times.svg';
import IconInfoGray from './icon-infogray.svg';
import IconCopy from './icon-copy.svg';
import IconLove from './icon-love.svg';
import IconDemo from './icon-demo.svg';
import IconImported from './icon-imported.svg';
import IconWarn from './icon-warn.svg';
import IconClose from './icon-close.svg';
import IconRadioChecked from './icon-radio-checked.svg';
import IconRadio from './icon-radio.svg';
import IconSearch from './icon-search.svg';
import IconMenuNav from './icon-menu-nav.svg';
import IconSave from './icon-save.svg';
import IconFontControl from './icon-font-control.svg';
import IconMonitor from './icon-monitor.svg';
import IconTablet from './icon-tablet.svg';
import IconPhone from './icon-phone.svg';
import IconWidescreen from './icon-widescreen.svg';
import IconLaptop from './icon-laptop.svg';
import IconTabletLandscape from './icon-tablet-landscape.svg';
import IconPhoneLandscape from './icon-phone-landscape.svg';
import IconSearchArrow from './icon-search-arrow.svg';
import IconHilight from './icon-hilight.svg';
import IconGlobal from './icon-global.svg';
import IconPaint from './icon-paint.svg';
import IconDrop from './icon-drop.svg';

export const EssentialLogoSVG = () => {
    return <EssentialLogo />;
};

export const NavActiveSVG = () => {
    return <NavActive />;
};

export const IconInfoGraySVG = () => {
    return <IconInfoGray />;
};

export const IconCheckSVG = () => {
    return <IconCheck />;
};

export const IconTimesSVG = () => {
    return <IconTimes />;
};

export const IconCopySVG = () => {
    return <IconCopy />;
};

export const SvgIconLove = () => {
    return <IconLove />;
};

export const IconDemoSVG = () => {
    return <IconDemo />;
};

export const IconImportedSVG = () => {
    return <IconImported />;
};

export const IconWarnSVG = () => {
    return <IconWarn />;
};

export const IconCloseSVG = () => {
    return <IconClose />;
};

export const IconRadioCheckedSVG = () => {
    return <IconRadioChecked />;
};

export const IconRadioSVG = () => {
    return <IconRadio />;
};

export const IconSearchSVG = () => {
    return <IconSearch />;
};

export const IconMenuNavSVG = () => {
    return <IconMenuNav />;
};

export const IconSaveSVG = () => {
    return <IconSave />;
};

export const IconFontControlSVG = () => {
    return <IconFontControl />;
};

export const IconMonitorSVG = () => {
    return <IconMonitor />;
};

export const IconTabletSVG = () => {
    return <IconTablet />;
};

export const IconPhoneSVG = () => {
    return <IconPhone />;
};

export const IconWidescreenSVG = () => {
    return <IconWidescreen />;
};

export const IconLaptopSVG = () => {
    return <IconLaptop />;
};

export const IconTabletLandscapeSVG = () => {
    return <IconTabletLandscape />;
};

export const IconPhoneLandscapeSVG = () => {
    return <IconPhoneLandscape />;
};

export const IconSearchArrowSVG = () => {
    return <IconSearchArrow />;
};

export const IconHilightSVG = () => {
    return <IconHilight />;
};

export const IconGlobalSVG = () => {
    return <IconGlobal />;
};

export const IconPaintSVG = () => {
    return <IconPaint />;
};

export const IconDropSVG = () => {
    return <IconDrop />;
};

export const EmptySvg = ({ size = 25, ...props }) => {
    return <svg {...props} width={size} height={size} viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="currentColor">
        <path d="M8 1a7 7 0 1 1-7 7 7.008 7.008 0 0 1 7-7zM2 8c0 1.418.504 2.79 1.423 3.87l8.447-8.447A5.993 5.993 0 0 0 2 8zm12 0c0-1.418-.504-2.79-1.423-3.87L4.13 12.577A5.993 5.993 0 0 0 14 8z" />
    </svg>;
};

export const HeartFullSvg = ({ size = 16, ...props }) => {
    return <svg {...props} width={size} height={size} viewBox="0 0 14 12.31" xmlns="http://www.w3.org/2000/svg">
        <g transform="translate(-1 -2)"><path d="m13.88 6.41a2.72 2.72 0 0 1 -.69 1.21l-5.19 5.2-5.23-5.2a2.71 2.71 0 0 1 -.44-.57 2.63 2.63 0 0 1 -.27-.65 3.25 3.25 0 0 1 -.06-.69 3.36 3.36 0 0 1 .06-.71 2.48 2.48 0 0 1 .27-.65 2.71 2.71 0 0 1 .44-.57 3 3 0 0 1 .89-.6 2.71 2.71 0 0 1 3 .59l1.34 1.37 1.34-1.37a2.71 2.71 0 0 1 3-.59 3 3 0 0 1 .89.6 2.37 2.37 0 0 1 .43.57 2.73 2.73 0 0 1 .34 1.34 2.92 2.92 0 0 1 -.06.72z" /><path d="m15 5.78a3.66 3.66 0 0 1 -.49 1.83 3.3 3.3 0 0 1 -.6.79l-5.91 5.91-5.91-5.91a3.88 3.88 0 0 1 -.61-.79 3.61 3.61 0 0 1 -.36-.89 3.73 3.73 0 0 1 -.12-.94 3.75 3.75 0 0 1 .12-1 3.6 3.6 0 0 1 1-1.69 3.71 3.71 0 0 1 4.05-.81 3.85 3.85 0 0 1 1.13.72v.06l.7.68.65-.65.05-.09a3.85 3.85 0 0 1 1.16-.75 3.71 3.71 0 0 1 4.05.81 3.3 3.3 0 0 1 .6.79 3.56 3.56 0 0 1 .37.9 3.75 3.75 0 0 1 .12 1.03z" /></g>
    </svg>;
};

export const GlobalMiniSvg = ({ isGlobal = false, ...props }) => {
    return <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
        <path d="M1 5H9M1 5C1 7.20914 2.79086 9 5 9M1 5C1 2.79086 2.79086 1 5 1M9 5C9 7.20914 7.20914 9 5 9M9 5C9 2.79086 7.20914 1 5 1M5 1C6.00051 2.09534 6.5691 3.51681 6.6 5C6.5691 6.48319 6.00051 7.90466 5 9M5 1C3.99949 2.09534 3.4309 3.51681 3.4 5C3.4309 6.48319 3.99949 7.90466 5 9" stroke={`${isGlobal ? '#9747FF' : '#7D8292'}`} strokeWidth="0.490909" strokeLinecap="round" strokeLinejoin="round" />
    </svg>;
};

export const GlobalSettingSvg = () => {
    return <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
        <path d="M1.75 4.66669L8.75 4.66669M8.75 4.66669C8.75 5.63319 9.5335 6.41669 10.5 6.41669C11.4665 6.41669 12.25 5.63319 12.25 4.66669C12.25 3.70019 11.4665 2.91669 10.5 2.91669C9.5335 2.91669 8.75 3.70019 8.75 4.66669ZM5.25 9.33335L12.25 9.33335M5.25 9.33335C5.25 10.2999 4.4665 11.0834 3.5 11.0834C2.5335 11.0834 1.75 10.2999 1.75 9.33335C1.75 8.36686 2.5335 7.58335 3.5 7.58335C4.4665 7.58335 5.25 8.36686 5.25 9.33335Z" stroke="#7D8292" strokeLinecap="round" strokeLinejoin="round" />
    </svg>;
};

export const LinkSvg = ({ active = false, ...props }) => {
    return <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
        <path d="M9.07379 12.8198L7.92621 13.8909C6.34175 15.3697 3.77282 15.3697 2.18835 13.8909C0.603883 12.412 0.603883 10.0144 2.18835 8.53553L3.33592 7.46447M13.6641 8.53553L14.8116 7.46447C16.3961 5.98563 16.3961 3.58796 14.8116 2.10913C13.2272 0.630291 10.6583 0.630291 9.07379 2.10913L7.92621 3.18019M5.6599 10.6507L11.3401 5.34923" stroke={active ? '#9747FF' : '#7D8292'} strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round" />
    </svg>;
};

export const ContrasSvg = () => {
    return <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
        <path d="M10.9993 20.1666C5.93674 20.1666 1.83268 16.0625 1.83268 10.9999C1.83268 5.93731 5.93674 1.83325 10.9993 1.83325C16.062 1.83325 20.166 5.93731 20.166 10.9999C20.166 16.0625 16.062 20.1666 10.9993 20.1666Z" stroke="#515676" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M10.9993 16.9583C7.70865 16.9583 5.04102 14.2906 5.04102 10.9999C5.04102 7.70922 7.70865 5.04159 10.9993 5.04159V16.9583Z" stroke="#515676" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
    </svg>;
};

export const UploadSvg = () => {
    return <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
        <path d="M6.66602 13.3333L9.99935 10M9.99935 10L13.3327 13.3333M9.99935 10V17.5M16.666 13.9524C17.6839 13.1117 18.3327 11.8399 18.3327 10.4167C18.3327 7.88536 16.2807 5.83333 13.7493 5.83333C13.5673 5.83333 13.3969 5.73833 13.3044 5.58145C12.2177 3.73736 10.2114 2.5 7.91602 2.5C4.46424 2.5 1.66602 5.29822 1.66602 8.75C1.66602 10.4718 2.36222 12.0309 3.48847 13.1613" stroke="#475467" strokeWidth="1.66667" strokeLinecap="round" strokeLinejoin="round" />
    </svg>;
};

export const TrashSvg = () => {
    return <svg xmlns="http://www.w3.org/2000/svg" width="12" height="15" viewBox="0 0 8 10" fill="none">
        <path d="M5.33333 2.6V2.28C5.33333 1.83196 5.33333 1.60794 5.26067 1.43681C5.19676 1.28628 5.09477 1.16389 4.96933 1.08719C4.82672 1 4.64004 1 4.26667 1H3.73333C3.35996 1 3.17328 1 3.03067 1.08719C2.90523 1.16389 2.80324 1.28628 2.73933 1.43681C2.66667 1.60794 2.66667 1.83196 2.66667 2.28V2.6M3.33333 4.8V6.8M4.66667 4.8V6.8M1 2.6H7M6.33333 2.6V7.08C6.33333 7.75206 6.33333 8.0881 6.22434 8.34479C6.12847 8.57058 5.97549 8.75416 5.78732 8.86921C5.57341 9 5.29339 9 4.73333 9H3.26667C2.70661 9 2.42659 9 2.21268 8.86921C2.02451 8.75416 1.87153 8.57058 1.77566 8.34479C1.66667 8.0881 1.66667 7.75206 1.66667 7.08V2.6" stroke="white" strokeWidth="0.5" strokeLinecap="round" strokeLinejoin="round" />
    </svg>;
};