<?php

declare (strict_types=1);
namespace BitPayVendor\unit\Logger;

use BitPayVendor\BitPaySDK\Logger\BitPayLogger;
use BitPayVendor\BitPaySDK\Logger\EmptyLogger;
use BitPayVendor\BitPaySDK\Logger\LoggerProvider;
use BitPayVendor\PHPUnit\Framework\TestCase;
class LoggerTest extends TestCase
{
    public function testGetEmptyLoggerAsDefault() : void
    {
        self::assertInstanceOf(EmptyLogger::class, LoggerProvider::getLogger());
    }
    public function testChangeDefaultLogger() : void
    {
        $customLogger = new class implements BitPayLogger
        {
            public function logRequest(string $method, string $endpoint, ?string $json) : void
            {
            }
            public function logResponse(string $method, string $endpoint, ?string $json) : void
            {
            }
            public function logError(?string $message) : void
            {
            }
        };
        LoggerProvider::setLogger($customLogger);
        self::assertSame($customLogger, LoggerProvider::getLogger());
    }
}
